#****************************************************************************
#**
#**  File     :  /lua/unit.lua
#**  Author(s):  John Comes, David Tomandl, Gordon Duclos
#**
#**  Summary  : The Unit lua module
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************


local oldUnit=Unit
Unit = Class(oldUnit) {
    
	OnCreate = function(self)
    	oldUnit.OnCreate(self)
    	self.VeteranLevel = 0
    end,

    ##########################################################################################
    ## VETERANCY
    ##########################################################################################
    
    #This function should be used for kills made through the script, since kills through the engine (projectiles etc...) are already counted.
    AddKills = function(self, numKills)
        #Add the kills, then check veterancy junk.
        local unitKills = self:GetStat('KILLS', 0).Value + numKills
        self:SetStat('KILLS', unitKills)
        
        local vet = self:GetBlueprint().Veteran or Game.VeteranDefault
        
        local vetLevels = table.getsize(vet)
        if self.VeteranLevel == vetLevels then
            return
        end

        local nextLvl = self.VeteranLevel + 1
        local nextKills = vet[('Level' .. nextLvl)]
        
        #Since we could potentially be gaining a lot of kills here, check if we gained more than one level
        while unitKills >= nextKills and self.VeteranLevel ~= vetLevels do
            self:SetVeteranLevel(nextLvl)
            
            nextLvl = self.VeteranLevel + 1
            nextKills = vet[('Level' .. nextLvl)]
        end 
    end,

    # use this to go through the AddKills function rather than directly setting veterancy
    SetVeterancy = function(self, veteranLevel)
        veteranLevel = veteranLevel or 0
        if veteranLevel == 0 then
            return
        end
        local bp = self:GetBlueprint()
        if bp.Veteran['Level1'] then
			##LOG('unit:AddKills')
            self:AddKills(bp.Veteran['Level1']*veteranLevel)
        elseif import('/lua/game.lua').VeteranDefault['Level'..veteranLevel] then
            ##LOG('VeteranDefault.unit:AddKills')
        	self:AddKills(import('/lua/game.lua').VeteranDefault['Level'..veteranLevel])
        else
            error('Invalid veteran level - ' .. veteranLevel)
        end 
    end, 

    #Check to see if we should veteran up.
    CheckVeteranLevel = function(self)
        local bp = self:GetBlueprint().Veteran
        #There is no veteran block in the bp, return
        if not bp then
            bp = Game.VeteranDefault
        end
        #LOG('*DEBUG: Vet Table = ', repr(bp))
        #We add 1 because we get this before the stat gets updated
        local unitKills = self:GetStat('KILLS', 0).Value + 1
        #LOG('*DEBUG: Veteran Kills = ', repr(unitKills))
        #We are already at the highest veteran level, return
        #if self.VeteranLevel == table.getsize(bp) then
        #    return
        #end

        local nextLvl = self.VeteranLevel + 1
        local nextKills = bp[('Level1')]*nextLvl
        if unitKills >= nextKills then
        	self:SetVeteranLevel(nextLvl)
        end
    end,

    #Set the veteran level to the level specified
    SetVeteranLevel = function(self, level)
        #LOG(' ')
       # LOG('*DEBUG: VETERAN UP! LEVEL ', repr(level))
        local old = self.VeteranLevel
        self.VeteranLevel = level

        # Apply default veterancy buffs
        local buffTypes = { 'Regen', 'Health', 'Damage','DamageArea','Range','Speed','Vision','OmniRadius','Radar','BuildRate','RateOfFire'}
        for k,bType in buffTypes do
            Buff.ApplyBuff( self, 'Veterancy' .. bType)
            #Buff.ApplyBuff( self, 'Veterancy' .. bType .. level )
        end
        
        
        
        # Inform all weapons that have veteraned - Damage already defaulted increase
        # Each weapon can override the buff if desired
        
        # TODO: Enable per weapon buffs again
        #for i = 1, self:GetWeaponCount() do
            #local wep = self:GetWeapon(i)
            #wep:OnVeteranLevel(old, level)
        #end

        # Get any overriding buffs if they exist
        local bp = self:GetBlueprint().Buffs
        #Check for unit buffs
        
   		if bp then
        	for bLevel,bData in bp do
        		if (bLevel == 'Any' or bLevel == 'Level'..level) then
        			for bType,bValues in bData do
	        			local buffName = self:CreateUnitBuff(bLevel,bType,bValues)
	        			if buffName then
	        				Buff.ApplyBuff( self, buffName )
	                    end
        			end
        		end
        	end   		
        end

        self:GetAIBrain():OnBrainUnitVeterancyLevel(self, level)
        self:DoUnitCallbacks('OnVeteran')
    end,
    
    CreateUnitBuff = function(self, levelName, buffType, buffValues)
    	
    	# Generate a buff based on the unitId
        local buffName = self:GetUnitId() .. levelName .. buffType
        
        # Create the buff if needed
        if not Buffs[buffName] then
            BuffBlueprint {
                Name = buffName,
                DisplayName = buffName,
                BuffType = buffType,
                Stacks = buffValues.Stacks,
                #self.BuffTypes[buffType].BuffStacks,
                Duration = buffValues.Duration,
                Affects = buffValues.Affects,
            }
        end
        
        # Return the buffname so the buff can be applied to the unit
        return buffName
    end,
   
  	UpdateProductionValues = function(self)
        local bpEcon = self:GetBlueprint().Economy
        if not bpEcon then return end
        self:SetProductionPerSecondEnergy( (self.EnergyProdMod or bpEcon.ProductionPerSecondEnergy or 0)* (self.EnergyProdAdjMod or 1) )
        self:SetProductionPerSecondMass( (self.MassProdMod or bpEcon.ProductionPerSecondMass or 0) * (self.MassProdAdjMod or 1) )
    end,


}

