#****************************************************************************
#**
#**  File     :  /lua/sim/Weapon.lua
#**  Author(s):  John Comes
#**
#**  Summary  : The base weapon class for all weapons in the game.
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************

local oldWeapon = Weapon
Weapon = Class(oldWeapon) {
    
	OnCreate = function(self)
		oldWeapon.OnCreate(self)
		local bp = self:GetBlueprint()
		self.DamageRadius =	bp.DamageRadius
		self.Damage = bp.Damage
		self.rangeMod = 1
	end,
	
	CreateProjectileForWeapon = function(self, bone)
		
    	local proj = oldWeapon.CreateProjectileForWeapon(self, bone)
    	local Lifetime = self:GetBlueprint().ProjectileLifetime #or proj:GetBlueprint().Physics.Lifetime or 1
    	if Lifetime == 0 then Lifetime = proj:GetBlueprint().Physics.Lifetime end
    	#LOG('LifeTime:',self:GetBlueprint().ProjectileLifetime)
    	#LOG('LifeTime:',proj:GetBlueprint().Physics.Lifetime)
    	#LOG('LifeTime:' .. Lifetime)
    	
    	#if Lifetime then
    		proj:SetLifetime(self.rangeMod*Lifetime)
    	#end
    	return proj
    end,
	

    GetDamageTable = function(self)
        local damageTable = oldWeapon.GetDamageTable(self)
    	#local weaponBlueprint = self:GetBlueprint()
        #local damageTable = {}
        damageTable.DamageRadius = (self.DamageRadius or 0)
        damageTable.DamageAmount = (self.Damage or 0)
        
        #damageTable.DamageAmount = weaponBlueprint.Damage + (self.DamageMod or 0)
        #damageTable.DamageType = weaponBlueprint.DamageType
        #damageTable.DamageFriendly = weaponBlueprint.DamageFriendly
        #if damageTable.DamageFriendly == nil then
        #    damageTable.DamageFriendly = true
        #end
        #damageTable.CollideFriendly = weaponBlueprint.CollideFriendly or false
        #damageTable.DoTTime = weaponBlueprint.DoTTime
        #damageTable.DoTPulses = weaponBlueprint.DoTPulses
        #damageTable.MetaImpactAmount = weaponBlueprint.MetaImpactAmount
        #damageTable.MetaImpactRadius = weaponBlueprint.MetaImpactRadius
        #Add buff
        #damageTable.Buffs = {}
        #if weaponBlueprint.Buffs != nil then
        #    for k, v in weaponBlueprint.Buffs do
        #        damageTable.Buffs[k] = {}
        #        damageTable.Buffs[k] = v
        #    end   
        #end     
        #remove disabled buff
        #if (self.Disabledbf != nil) and (damageTable.Buffs != nil) then
        #    for k, v in damageTable.Buffs do
        #        for j, w in self.Disabledbf do
        #            if v.BuffType == w then
        #                #Removing buff
        #                table.remove( damageTable.Buffs, k )
        #            end
        #        end
        #    end  
        #end  
        return damageTable
    end,

    
}
