do
local oldModBP = ModBlueprints

function ModBlueprints(all_bps)
	oldModBP(all_bps)
    
	local once = true
    for id,bp in all_bps.Unit do
		if bp.Defense.RegenRate == nil then
    		bp.Defense.RegenRate = 0
		end
		local RegenMod = 0.7*(50 - 1 / (0.00000060257 * bp.Defense.MaxHealth + 0.020016))
        bp.Defense.RegenRate = bp.Defense.RegenRate + RegenMod
        
        local regenVal
        if bp.Buffs and bp.Buffs.Regen and bp.Buffs.Regen.Level1 then
        	regenVal = bp.Buffs.Regen.Level1
        else
        	regenVal = 1
        end
        
        if not bp.Buffs then
        	bp.Buffs = {}
        end
        
        if not bp.Buffs.Any then
        	bp.Buffs.Any = {}
        end
        
        if not bp.Buffs.Any.VETERANCYREGEN then
        	bp.Buffs.Any.VETERANCYREGEN = {
	    		Stacks = 'ALWAYS',
			    Duration = -1,
			    Affects = {
			        Regen = {
			            Add = regenVal,
			            Mult = 1,
			        },
	    		},
    		}
        end
    end
end

end
