#****************************************************************************
#**  Summary  :  Seraphim Sub Commander Script
#****************************************************************************

local oldXSL0301 = XSL0301
XSL0301 = Class(oldXSL0301) {
    
    CreateEnhancement = function(self, enh)
        SWalkingLandUnit.CreateEnhancement(self, enh)
        local bp = self:GetBlueprint().Enhancements[enh]
        if not bp then return end
        
        #Engineering Throughput Upgrade
        if enh =='EngineeringThroughput' then
            if not Buffs['SeraphimSCUBuildRate'] then
                BuffBlueprint {
                    Name = 'SeraphimSCUBuildRate',
                    DisplayName = 'SeraphimSCUBuildRate',
                    BuffType = 'SCUBUILDRATE',
                    Stacks = 'ALWAYS',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bp.NewBuildRate,
                            Mult = 1,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'SeraphimSCUBuildRate')
        
        #Enhanced Sensor Systems
        elseif enh == 'EnhancedSensors' then
        	if not Buffs['SeraSCUEnhancedSensors'] then
                BuffBlueprint {
                    Name = 'SeraSCUEnhancedSensors',
                    DisplayName = 'SeraSCUEnhancedSensors',
                    BuffType = 'SeraSCUEnhancedSensors',
                    Stacks = 'ALWAYS',
                    Duration = -1,
                    Affects = {
                        VisionRadius = {
                            Add =  bp.NewVisionRadius,
                            Mult = 1,
                        },
                        OmniRadius = {
                            Add = bp.NewOmniRadius,
                            Mult = 1.0,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'SeraSCUEnhancedSensors')
        elseif enh == 'EnhancedSensorsRemove' then
            Buff.RemoveBuff(self,'SeraSCUEnhancedSensors',false)
        else
        	oldXSL0301.CreateEnhancement(self, enh)
        end
    end,
}

TypeClass = XSL0301
